#ifndef _H_BITMAP
#define _H_BITMAP

#include "RPK.h"

typedef unsigned int bmcol_t;

typedef struct
{
	int w, h;
	bmcol_t *pixels;
} Bmp_t;

Bmp_t Bmp_Create(int width, int height);
Bmp_t Bmp_CreateFromPAKEntry(const RPKFile *rpak, const char *name);

enum BmpFonts { BMPFONT_MINISERIF, BMPFONT_TINY };

void Bmp_InitFonts(const RPKFile *rpak);
void Bmp_DestroyFonts(void);

void Bmp_SetActiveFont(enum BmpFonts);
void Bmp_TextSize(const char *msg, int *width, int *height, int wrapDist);
void Bmp_DrawGlyph(Bmp_t *bmp, char c, bmcol_t col, int xo, int yo);
void Bmp_DrawText(Bmp_t *bmp, const char *msg, bmcol_t col, int xo, int yo, int wrapDist);

void Bmp_Resize(Bmp_t *bmp, int w, int h);

void Bmp_Blit(Bmp_t *dst, Bmp_t *src, int xo, int yo);
void Bmp_BlitRegion(Bmp_t *dst, Bmp_t *src, int xo, int yo, int rx, int ry, int rw, int rh);
void Bmp_BlitRegionScaled(Bmp_t *dst, Bmp_t *src, int xo, int yo, int rx, int ry, int rw, int rh, int scale);
void Bmp_Clear(Bmp_t *, bmcol_t col);
void Bmp_FillRegion(Bmp_t *, bmcol_t col, int xo, int yo, int w, int h);

void Bmp_Destroy(Bmp_t *);

#endif
