/* ExMath.h: Extended math library */

#ifndef _H_EXMATH
#define _H_EXMATH

#define MATH_PI     3.1415927f
#define MATH_HALFPI 1.5707964f

#define DEG_TO_RAD(a) ((a) * (MATH_PI / 180.f))
#define RAD_TO_DEG(a) ((a) / (MATH_PI / 180.f))

#define MATH_MIN(a, b) (((a) < (b)) ? (a) : (b))
#define MATH_MAX(a, b) (((a) > (b)) ? (a) : (b))
#define MATH_LERP(a, b, t) ((a) + (t) * ((b) - (a)))

/* p is an int ranging from 0 to 100 */
#define RNG_CHANCE(p) ((Math_Random() % 100) < (unsigned int)(p))
#define RNG_RANGE(a, b) ((Math_Random() % ((b)-(a))) + (a))

/* Determines whether the two rects share the same space */
#define RECT_INTERSECTS(a, b) ((a).x0 <= (b).x1 && (a).x1 >= (b).x0) && ((a).y0 <= (b).y1 && (a).y1 >= (b).y0)

/* Determines whether b is fully contained by a */
// TODO: #define RECT_CONTAINS(a, b)

// Using SDL_ functions here to avoid needing to link -lm
#define Math_Sin(x) SDL_sinf(x)
#define Math_Cos(x) SDL_cosf(x)
#define Math_Sqrt(x) SDL_sqrtf(x)
#define Math_Atan2(y, x) SDL_atan2f(y, x)
#define Math_Abs(x) SDL_fabsf(x)
#define Math_Pow(x, y) SDL_powf(x, y)
#define Math_Floor(x) SDL_floorf(x)
#define Math_Ceil(x) SDL_ceilf(x)
#define Math_IAbs(x) SDL_abs(x)

struct Rect
{
	float x0, y0;
	float x1, y1;
};

struct IntRect
{
	int x0, y0;
	int x1, y1;
};

void Math_SeedRNG(unsigned long);

unsigned Math_Random(void);
float Math_RandomFloat(void);

#endif
