#ifndef _H_INVENTORY
#define _H_INVENTORY

#include <stdbool.h>

#include "Item.h"

#define INV_GRID_WIDTH 8
#define INV_GRID_HEIGHT 4
#define INV_GRID_SIZE (INV_GRID_WIDTH * INV_GRID_HEIGHT)

#define INV_HAND_SLOT INV_GRID_SIZE
#define INV_HAND_SLOT2 (INV_HAND_SLOT + 1)
#define INV_BELT_SLOT (INV_HAND_SLOT + 2)

#define INV_SIZE (INV_GRID_SIZE + 5)

enum
{
	SLOT_EMPTY        = 0,        // No item data is stored and the slot is empty.
	SLOT_CONTAINSITEM = (1 << 0), // Item data is stored at this position.
	SLOT_ISOCCUPIED   = (1 << 1), // No item data here necessarily, but an item is using this slot.
};

typedef struct Inventory
{
	Item_t items[INV_SIZE];
	unsigned char slots[INV_SIZE];
	bool isDraggingItem;	// When dragging an item with the mouse
	Item_t dragItem;
} inventory_t;

// Core inventory functions
// All code that interacts with the inventory should do it through these five functions only.
Item_t *Inv_GetItem(inventory_t *inv, int slot, int *itemSlot);
bool Inv_PutItem(inventory_t *inv, Item_t, int slot);
void Inv_Clear(inventory_t *inv);
void Inv_ClearItem(inventory_t *inv, int slot);
bool Inv_CanPut(inventory_t *inv, const Item_t *, int slot);

bool Inv_AutoPlace(inventory_t *inv, Item_t);

#endif
