#include "Log.h"

#include <SDL.h>
#include "Console.h"

#define LOG_BUFFER_SIZE 1024

void Msg_Info(const char *fmtstr, ...)
{
	static char msgbuf[LOG_BUFFER_SIZE];

	va_list args;
	va_start(args, fmtstr);
	SDL_vsnprintf(msgbuf, LOG_BUFFER_SIZE, fmtstr, args);
	va_end(args);

	SDL_Log("%s", msgbuf);
}

void Msg_Warning(const char *fmtstr, ...)
{
	static char msgbuf[LOG_BUFFER_SIZE];

	va_list args;
	va_start(args, fmtstr);
	SDL_vsnprintf(msgbuf, LOG_BUFFER_SIZE, fmtstr, args);
	va_end(args);

	SDL_Log("[WARN]: %s", msgbuf);
	Console_PrintMsg("%s", msgbuf);
}

void Msg_Error(const char *fmtstr, ...)
{
	static char msgbuf[LOG_BUFFER_SIZE];

	va_list args;
	va_start(args, fmtstr);
	SDL_vsnprintf(msgbuf, LOG_BUFFER_SIZE, fmtstr, args);
	va_end(args);

	SDL_Log("[ERR]: %s", msgbuf);
	SDL_ShowSimpleMessageBox(SDL_MESSAGEBOX_WARNING, "Error", msgbuf, NULL);
}

void Msg_Fatal(const char *fmtstr, ...)
{
	static char msgbuf[128];

	va_list args;
	va_start(args, fmtstr);
	SDL_vsnprintf(msgbuf, 128, fmtstr, args);
	va_end(args);

	SDL_Log("[FATAL]: %s", msgbuf);
	SDL_ShowSimpleMessageBox(SDL_MESSAGEBOX_ERROR, "Fatal Error", msgbuf, NULL);

	exit(1);
}
