#ifndef _H_LOG
#define _H_LOG

#ifdef _MSC_VER
#define NORETURN __declspec(noreturn)
#else
#define NORETURN __attribute__ ((noreturn))
#endif

/* Helpful information for debugging, but doesn't represent any problem. */
void Msg_Info(const char *fmtstr, ...);

/* Something is unusual, but won't have much of an affect on gameplay. */
void Msg_Warning(const char *fmtstr, ...);

/* Something went wrong and will affect gameplay, but the game can still continue. */
void Msg_Error(const char *fmtstr, ...);

/* An error occurred that makes it impossible for the game to continue running. */
NORETURN void Msg_Fatal(const char *fmtstr, ...);

#endif
