/**
 * @file Net.h
 *
 * Simple network interface over UDP
 */

#ifndef _H_NET
#define _H_NET

#include <stdint.h>

#define NET_STATUS_CONNECTED 0
#define NET_STATUS_DISCONNECTED -1

typedef struct
{
	uint32_t addr;
	uint16_t port;
} Netaddr;

struct NetConnection
{
	Netaddr serverAddr;
	enum { NET_CONN_SERVER, NET_CONN_CLIENT } connType;
	int status;
	int socket;
};

int Net_Init(void);
void Net_Cleanup(void);

int Net_OpenServer(struct NetConnection *);
int Net_ConnectClient(struct NetConnection *, const char *addrString);
void Net_Close(struct NetConnection *);

// Generates a time to be used for the timestamp or for comparing against a timestamp
int Net_CurrentTimeMs(void);

char *Net_AddrToString(Netaddr addr);

void Net_SendPacket(struct NetConnection *conn, Netaddr destAddr, void *data, int size);
/**
 * Reads the next available packet, if any.
 * Returns 0 if there are no packets to be read.
 * The data pointer is set, but its memory will be overwritten when the next packet is read, so data should be copied before reading another packet.
 */
int Net_ReadNextPacket(struct NetConnection *conn, Netaddr *fromAddr, void **data, int *size);

#endif
