/* Particle:
 *
 * Handles ingame particle setup
 */

#ifndef _H_PAR
#define _H_PAR

#define NUM_PARTICLES 1024
#define GRAVITY 9.81f

// Particle types. Determines the behaviour of particles each frame.
enum
{
	// Particle has simple physics, will bounce off walls, etc.
	PTYPE_PHYSICS,
	// Particle floats in a specific direction, resets when it hits floor/ceiling.
	PTYPE_ENVIRONMENT
};

typedef struct {
	float x, y, z;
	float velX, velY, velZ;
	int colour;
	int type;
	float lifespan;
} Particle;

// Initialises particles pos, velocity, and colour
void initParticles(void);
// Updates particle position based on time & velocity
void updateParticles(float deltaTime);
// Renders SDL points & colours for particles
void renderParticles(void);
// Removes all particles from the world
void clearParticles(void);

void particleBurst(float x, float y, float z, float xd, float yd, float zd, int col, int count);
void EnvironmentParticles(void);

#endif
