#ifndef _H_PLAYER
#define _H_PLAYER

#include <stdbool.h>

#include "Entity.h"
#include "Inventory.h"
#include "netcode.h"

/* The maximum level a single stat can be leveled up to */
#define PLAYER_STAT_CAP 36
#define PLAYER_MANA_PER_ITL 20
#define PLAYER_MANA_PER_SECOND 0.10

struct PlayerDeathStatistics
{
	int kills, items;
	int dmgTaken, dmgDealt;
};

struct InputCmd
{
	// Amount of forward/backward movement
	float impulseForward;
	// Amount of left/right movement
	float impulseLateral;
	// Amount the player's view should rotate
	float rotDelta;
};

typedef struct Player
{
	Obj_t *entity;
	sprite_t *sprite;
	float viewBob;
	time itemCooldown;
	float manaTimer;
	struct PlayerDeathStatistics deathStatistics;
	int savedHealth, savedMaxHealth; // Used when deleting the entity and creating a new on upon level change
	struct InputCmd input;

	int str; /* Base damage added to any attacks*/
	int spd;
	int def; /* Any damage taken will be subtracted by a random number from 0 to `def` */
	int vit; /* The player's total health is 10*`vit` */
	int itl; /* Intelligence, this variable should be called 'int' but that's not allowed. */
	int mana, maxMana;

	int handSlot;
	unsigned short statPoints;
	unsigned short level;
	unsigned int xp;

	inventory_t inventory;
} player_t;

enum PlayerStatType { PLAYER_STAT_STR, PLAYER_STAT_DEF, PLAYER_STAT_SPD, PLAYER_STAT_VIT, PLAYER_STAT_INT };

/* Amount of XP required to reach each level */
extern const unsigned int LEVELXPS[];

extern int Player_EntityTypeId;
extern int Player_StateBaseOffset;

void Player_Reset(player_t *player);

void Player_DoMoveTick(player_t *player, float deltaTime);

/* Gives XP to the player and levels up if needed */
void Player_AwardXP(player_t *player, int xp);
bool Player_CanUpgradeStat(player_t *player, enum PlayerStatType stat);
void Player_UpgradeStat(player_t *player, enum PlayerStatType stat);

void Player_ApplyStatsToEntity(player_t *player);

void Player_BreakItem(player_t *player, Item_t *item);
void Player_UseItem(player_t *player);
int Player_UseDoors(float x, float y, float rot);

#endif
