#ifndef _H_GFX
#define _H_GFX

#include "Bitmap.h"
#include "Inventory.h"
#include "RPK.h"
#include "Particle.h"

// TODO: Renderer improvements:
// - Store textures in column-major format
// The algorithm
// 1. Raycast walls like usual
//		Draw vertical stripes of textures
//		Write distances to 1D zbuffer
// 2. Fill in floor where needed
// 3. Draw sky if needed, can be drawn with vertical columns
// 		Use information from raycasting to determine bottom from each column?
// 4. Collect all sprites needed and sort by distance
//		Quickly discard sprites based on view frustum and furthest zbuf value
// 5. Draw sprites, using zbuf to discard hidden columns and clipping top/bottom using dist+floor/ceil height

enum SpriteFx
{
	SPRITEFX_NONE,
	SPRITEFX_GLOW,
	SPRITEFX_BLUR,
	SPRITEFX_INVERT,
	SPRITEFX_DMGRED
};

void Gfx_Init(const RPKFile *rpak, Bmp_t *framebuffer);
void Gfx_Cleanup(void);
void Gfx_Resize(int width, int height);

void Gfx_ClearViewport(void);
void Gfx_SetCameraPos(float x, float y, float z, float rot);

void Gfx_DrawWalls(void);
void Gfx_DrawFloor(void);
void Gfx_DrawSprite(float xpos, float ypos, float zpos, enum SpriteFx fx, Bmp_t* tex);
void Gfx_DrawParticle(Particle *particle);
void Gfx_DrawSky(void);

int Gfx_GetSpriteAngle(float rot);

int Gfx_LoadSprite(const RPKFile *rpak, const char *name);
Bmp_t *Gfx_GetSprite(int id, float angle);

void Gfx_DrawHeldItem(const Item_t *, float viewBob, int cooldown);
void Gfx_DrawHUDPanel(int health, int maxHealth, int invulTime, int lvlDepth);
void Gfx_DrawBossHealthBar(Bmp_t *, int health, int maxHealth);

void Gfx_DrawFireBackground(Bmp_t *);

#endif
