#ifndef _H_VM
#define _H_VM

#include <stdbool.h>

#include "Entity.h"
#include "Player.h"

struct VMContext
{
	Obj_t *obj;
	Obj_t *other;
	Item_t *item;
	player_t *player;
};

void VM_Init(const RPKFile *);
void VM_Cleanup(void);

int VM_RunBytecode(size_t start, struct VMContext *);
int VM_GetRegister(enum Register reg, struct VMContext *);
void VM_SetRegister(enum Register reg, int value, struct VMContext *);

#endif
