#ifndef H_INVGUI
#define H_INVGUI

#include "Bitmap.h"
#include "Inventory.h"
#include "Player.h"
#include "RPK.h"

// GUI-related functions; interactivity and rendering

// List of possible interactions in the menu, including slots, stat upgrades, clicking outside of the menu, and closing it.
enum
{
	INV_INTERACT_SLOT,
	INV_INTERACT_UPGRADESTAT_STR = INV_SIZE,
	INV_INTERACT_UPGRADESTAT_SPD,
	INV_INTERACT_UPGRADESTAT_DEF,
	INV_INTERACT_UPGRADESTAT_VIT,
	INV_INTERACT_UPGRADESTAT_INT,
	INV_INTERACT_DROP,	// Drop currently dragged item
	INV_INTERACT_NONE,
};

// Client-side: uses mouse position to check what was clicked and sends the interaction to the server.
int Inv_Click(inventory_t *inv, int x, int y);
void Inv_HandleControllerAxis(int axis, float value);
int Inv_ControllerClick(inventory_t *inv);

// Server-side: Handles the interaction from its id
void Inv_Interact(inventory_t *inv, player_t *player, int interact);
void Inv_OnClose(inventory_t *inv);

void Inv_InitGfx(const RPKFile *rpak);
void Inv_CleanupGfx(void);
void Inv_DrawItem(Bmp_t *screen, const Item_t *item, int x, int y);
void Inv_Render(Bmp_t *, inventory_t *inv, int mouseX, int mouseY);

#endif
