/* Shared definitions between Rovgend's Labyrinth game engine and tools */

#ifndef _H_ROVDEFS
#define _H_ROVDEFS

enum ObjFlags
{
	OF_BLOCKMOVEMENT = (1 << 0),
	OF_CANBEBLOCKED  = (1 << 1),
	OF_TICKER        = (1 << 2), // If this is not set, the object won't be updated every frame, but still responds to callbacks.
	                             // NOTE: This also means the object's state won't automatically switch either.
	OF_CANHURT       = (1 << 3),
	OF_CANUSE        = (1 << 4),
	OF_GLOW          = (1 << 5),
	OF_FLYING        = (1 << 6), /* Movement for flying objects is unaffected by water */
	OF_INVERT        = (1 << 7),
	OF_CANKNOCKBACK  = (1 << 8),
	OF_SHINE         = (1 << 9), /* Glows in the dark but doesn't cast light */
	OF_BLUR          = (1 << 10),
	OF_NOTARGET      = (1 << 11),
	OF_LAVAIMMUNE    = (1 << 12), /* Doesn't get damaged by hurting tiles */
	OF_DEAD          = (OF_TICKER | OF_CANKNOCKBACK | OF_NOTARGET),
	OF_NORMAL        = (OF_BLOCKMOVEMENT | OF_CANBEBLOCKED | OF_TICKER | OF_CANHURT | OF_CANKNOCKBACK),
	OF_ALL			 = 0xfff
};

enum BytecodeOp
{
	INSN_LOGI_ENDCODE = 0,
	INSN_LOGI_NOT,
	INSN_LOGI_AND,
	INSN_LOGI_OR,
	INSN_LOGI_JMP,
	INSN_LOGI_JMPIF,
	INSN_CORE_GET,
	INSN_CORE_SET,
	INSN_CORE_ADD,
	INSN_CORE_SUB,
	INSN_CORE_EQUALS,
	INSN_CORE_LESS,
	INSN_CORE_GREATER,
	INSN_CORE_LESSEQU,
	INSN_CORE_GREATEREQU,
	INSN_CORE_PUSH,
	INSN_CORE_POP,
	INSN_ACT_SETSTATE,
	INSN_ACT_NEXTSTATE,
	INSN_ACT_STOPMOVING,
	INSN_ACT_DELETEME,
	INSN_ACT_MOVE,
	INSN_ACT_MOVERANDOM,
	INSN_ACT_MOVEALLY,
	INSN_ACT_HITSCAN,
	INSN_ACT_HIT_SWEEP,
	INSN_ACT_HIT_RADIUS,
	INSN_ACT_SHOOT,
	INSN_ACT_PLAYSOUND,
	INSN_ACT_HURTOTHER,
	INSN_ACT_DELETEOTHER,
	INSN_ACT_THROWOTHER,
	INSN_ACT_STATMODOTHER,
	INSN_ACT_DROPITEM,
	INSN_ACT_DROPLOOT,
	INSN_ACT_HEAL,
	INSN_ACT_WARP,
	INSN_ACT_WARPTO,
	INSN_ACT_AWARDXP,
	INSN_ACT_PARTICLEBURST,
	INSN_ACT_ADDSTATMOD,
	INSN_ACT_SUMMONBURST,
	INSN_ACT_SAY,
	INSN_CND_CHANCE,
	INSN_CND_SEESENEMY,
	INSN_CND_ENEMYWITHIN,
	INSN_CND_SEESALLY,
	INSN_CND_ALLYWITHIN,
	INSN_CND_STATEIS,
	INSN_CND_OTHERIS
};

enum ImmType
{
	IMMTYPE_U8 = 0,
	IMMTYPE_U16,
	IMMTYPE_U32,
	IMMTYPE_FLOAT32,
	IMMTYPE_S8,
	IMMTYPE_S16,
	IMMTYPE_S32,
};

enum Register
{
	REG_GLOBAL0,
	REG_GLOBAL1,
	REG_GLOBAL2,
	REG_GLOBAL3,
	REG_FLOOR,
	REG_TIME,
	REG_NUMPLAYERS,
	REG_XP,
	REG_ENTITY_HEALTH,
	REG_ENTITY_DATA,
	REG_ENTITY_TEAM,
	REG_ITEM_DURABILITY,
	REG_ITEM_MANA,
	REG_ITEM_SPEED,
	REG_ITEM_RANGE,
	REG_ITEM_DAMAGE,
	REG_PLAYER_STR,
	REG_PLAYER_SPD,
	REG_PLAYER_DEF,
	REG_PLAYER_VIT,
	REG_PLAYER_INT,
	NUM_REGISTERS
};

// TODO This should go away, but for now...
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-variable"
static const char* registerNames[NUM_REGISTERS] = {
	"global0", "global1", "global2", "global3",
	"floor", "time", "numplayers", "xp",
	"health", "data", "team",
	"durability", "mana", "speed", "range", "damage",
	"str", "spd", "def", "vit", "int"
};
#pragma GCC diagnostic pop

enum SpecialDefs
{
	SPECIAL_DEF_CHEST = 0,
	SPECIAL_DEF_MIMIC,
	SPECIAL_DEF_LANTERN,
	NUM_SPECIAL_DEFS
};

#define STATE_NONE 0xffff

#endif
