#include "bitmap.h"

#include <malloc.h>

struct Bitmap Bmp_Create(int width, int height)
{
	struct Bitmap bmp;
	bmp.w = width;
	bmp.h = height;
	bmp.pixels = malloc(width * height * sizeof(pixel_t));
	return bmp;
}

void Bmp_Clear(struct Bitmap *bmp)
{
	int i;
	for (i = 0; i < bmp->w * bmp->h; i++) {
		bmp->pixels[i] = 0xff000000;
	}
}

void Bmp_Destroy(struct Bitmap *bmp)
{
	free(bmp->pixels);
}