#include "display.h"

#include <windows.h>

#include "bitmap.h"

static LPSTR g_szWndClassName = "KKEWnd";

static HWND  s_hwnd;
static HDC   s_hdc;
static BITMAPINFO s_bmi;

static int s_width, s_height, s_scale;

/* TODO: This is lazy, it should be stored in the window's extra data. */
struct InputKeys s_input;

static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static PAINTSTRUCT ps;
	switch (msg)
	{
	case WM_KEYDOWN:
		switch ((unsigned int)wParam) {
		/* Hardcoded! Because VK_x is an undeclared identifier apparently? */
		case 0x57:
			s_input.forward = 1;
			break;
		case 0x53:
			s_input.backward = 1;
			break;
		case 0x41:
			s_input.strafeLeft = 1;
			break;
		case 0x44:
			s_input.strafeRight = 1;
			break;
		case 0x25:
			s_input.turnLeft = 1;
			break;
		case 0x27:
			s_input.turnRight = 1;
			break;
		}
		break;
	case WM_KEYUP:
		switch (wParam) {
		case 0x57:
			s_input.forward = 0;
			break;
		case 0x53:
			s_input.backward = 0;
			break;
		case 0x41:
			s_input.strafeLeft = 0;
			break;
		case 0x44:
			s_input.strafeRight = 0;
			break;
		case 0x25:
			s_input.turnLeft = 0;
			break;
		case 0x27:
			s_input.turnRight = 0;
			break;
		}
		break;
	case WM_PAINT:
		BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		break;
	case WM_SIZE:
		PostMessage(hWnd, WM_PAINT, 0, 0);
		break;
	case WM_QUIT:
		DestroyWindow(hWnd);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, msg, wParam, lParam); 
	}
	return 0;
}

int Disp_CreateWindow(const char *title, int width, int height, int scale)
{
	WNDCLASSEX wc;

	DWORD dwStyle;
	RECT rc;
	int nClientWidth, nClientHeight;

	/* Register window class */
	wc.cbSize        = sizeof(WNDCLASSEX);
	wc.style         = 0;
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = GetModuleHandle(NULL);
	wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = g_szWndClassName;
	wc.hIconSm       = NULL;

	if (!RegisterClassEx(&wc))
	{
		MessageBox(NULL, "Failed to register window class!", "Fatal Error",
		           MB_ICONERROR | MB_OK);
		return 0;
	}

	/* Set the style to be a window that cannot be resized. */
	dwStyle = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX;

	/* Adjust a rectangle to get the desired client window size */
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = width * scale;
	rc.bottom = height * scale;
	
	AdjustWindowRectEx(&rc, dwStyle, FALSE, 0);
	nClientWidth = rc.right - rc.left;
	nClientHeight = rc.bottom - rc.top;

	s_hwnd = CreateWindowEx(0, g_szWndClassName, title, 
		dwStyle, CW_USEDEFAULT, CW_USEDEFAULT, nClientWidth, nClientHeight,
		NULL, NULL, GetModuleHandle(NULL), NULL);
	
	if (s_hwnd == NULL)
	{
		MessageBox(NULL, "Failed to create window!", "Fatal Error",
		           MB_ICONERROR | MB_OK);
		return 0;
	}
	
	s_hdc = GetDC(s_hwnd);

	ZeroMemory(&s_bmi, sizeof(BITMAPINFO));
	s_bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
	s_bmi.bmiHeader.biWidth       = width;
	s_bmi.bmiHeader.biHeight      = -height; /* Vertical axis must be flipped. */
	s_bmi.bmiHeader.biPlanes      = 1;
	s_bmi.bmiHeader.biBitCount    = 32;
	s_bmi.bmiHeader.biCompression = BI_RGB;

	ShowWindow(s_hwnd, SW_SHOW);
	UpdateWindow(s_hwnd);

	s_width  = width;
	s_height = height;
	s_scale  = scale;

	return 1;
}

int Disp_Update(struct InputKeys *pInput)
{
	static MSG msg;
	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) > 0)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		
		if (pInput != NULL)
			*pInput = s_input;

		if (msg.message == WM_QUIT)
		{
			return 0;
		}
	}
	return 1;
}

void Disp_Render(struct Bitmap *bmp)
{
	/* Copy pixel data into the Win32 bitmap. */
	StretchDIBits(s_hdc, 
		0, 0, s_width * s_scale, s_height * s_scale, 
		0, 0, bmp->w, bmp->h, 
		bmp->pixels, 
		&s_bmi, DIB_RGB_COLORS, SRCCOPY);
}

void Disp_Cleanup()
{
	ReleaseDC(s_hwnd, s_hdc);
	DestroyWindow(s_hwnd);
}