#include <windows.h>

#include <math.h>

#include "bitmap.h"
#include "display.h"
#include "level.h"
#include "viewport.h"

#define WIDTH  320
#define HEIGHT 260
#define SCALE  2

#define M_PI 3.14159f

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
	struct Bitmap bmp;
	struct Level level;
	
	struct InputKeys input;
	struct Camera camera;

	DWORD dwLastTime;
	float deltaTime;

	/* TODO: Properly handle command lines with more than just the filename. */
	LPSTR fileName = lpCmdLine;

	const float moveSpeed = 0.005f;
	const float turnSpeed = 0.005f;

	Disp_CreateWindow("KKE Game test", WIDTH, HEIGHT, SCALE);

	bmp = Bmp_Create(WIDTH, HEIGHT);
	
	/* Trim surrounding quotes from file path if needed. */
	if (*lpCmdLine == '"') {
		char *chptr = ++fileName;
		while (*chptr != 0 && *chptr != '"')
			++chptr;
		if (*chptr == '"')
			*chptr = 0;
	}

	if (Lvl_LoadFromFile(&level, fileName) != 0) {
		MessageBox(NULL, lpCmdLine, "Failed to load level!", MB_ICONERROR | MB_OK);
	}

	camera.x = level.header.startX;
	camera.y = 129;
	camera.z = level.header.startY;
	camera.rot = 0;

	dwLastTime = GetTickCount();
	while (Disp_Update(&input))
	{
		DWORD dwNow = GetTickCount();
		deltaTime = (float)dwNow - (float)dwLastTime;
		dwLastTime = dwNow;

		if (input.forward) {
			camera.z -= (float)cos(camera.rot) * moveSpeed * deltaTime;
			camera.x -= (float)sin(camera.rot) * moveSpeed * deltaTime;
		} else if (input.backward) {
			camera.z += (float)cos(camera.rot) * moveSpeed * deltaTime;
			camera.x += (float)sin(camera.rot) * moveSpeed * deltaTime;
		}

		if (input.strafeLeft) {
			camera.x += (float)sin(camera.rot + (M_PI / 2.f)) * moveSpeed * deltaTime;
			camera.z += (float)cos(camera.rot + (M_PI / 2.f)) * moveSpeed * deltaTime;
		} else if (input.strafeRight) {
			camera.x -= (float)sin(camera.rot + (M_PI / 2.f)) * moveSpeed * deltaTime;
			camera.z -= (float)cos(camera.rot + (M_PI / 2.f)) * moveSpeed * deltaTime;
		}

		if (input.turnLeft) {
			camera.rot -= turnSpeed * deltaTime;
		} else if (input.turnRight) {
			camera.rot += turnSpeed * deltaTime;
		}

		Bmp_Clear(&bmp);
		View_Render(&bmp, &camera, &level);

		Disp_Render(&bmp);
	}

	Disp_Cleanup();
	Bmp_Destroy(&bmp);
	return 0;
}
