#include "level.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <memory.h>

int Lvl_LoadFromFile(struct Level *lvl, const char *filename)
{
	HANDLE hFile;
	char *dataBuf;
	DWORD dwBytesRead;
	kke_header_t header;
	int i, offs, rc;

	hFile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (hFile == INVALID_HANDLE_VALUE)
		return -1;

	dataBuf = malloc(2048);
	if (ReadFile(hFile, dataBuf, 2048, &dwBytesRead, NULL) == FALSE)
		return -1;

	header.version      = *dataBuf;
	header.startX       = *(u16*)(dataBuf + 1);
	header.startY       = *(u16*)(dataBuf + 3);
	header.numSectors   = *(u16*)(dataBuf + 5);
	header.numHalfEdges = *(u16*)(dataBuf + 7);
	offs = 9;

	if (header.version != KKE_MAP_VERSION) {
		char errmsg[64];
		sprintf(errmsg, "Expected map version %d, file is version %d.",
			KKE_MAP_VERSION, header.version);
		MessageBox(NULL, errmsg, "Failed to load map", MB_ICONEXCLAMATION | MB_OK);
		/* We'll still continue loading, even though the data may be invalid. */
	}

	/* Check if the returned values are sane. */
	if (header.numSectors > KKE_MAX_SECTORS) {
		MessageBox(NULL, "Map contains too many sectors.", "Failed to load map", MB_ICONEXCLAMATION | MB_OK);
		rc = -1;
		goto cleanup;
	}


	lvl->header = header;
	for (i = 0; i < header.numSectors; i++) {
		kke_sector_t *sc = &lvl->sectors[i];
		sc->x0 = *(unsigned short*)(dataBuf + offs);
		sc->y0 = *(unsigned short*)(dataBuf + offs + 2);
		sc->x1 = *(unsigned short*)(dataBuf + offs + 4);
		sc->y1 = *(unsigned short*)(dataBuf + offs + 6);
		sc->floorHeight = *(dataBuf + offs + 8);
		sc->ceilHeight = *(dataBuf + offs + 9);
		offs += 10;
	}

	for (i = 0; i < header.numHalfEdges; i++) {
		kke_halfedge_t *edge = &lvl->edges[i];
		edge->x         = *(unsigned short*)(dataBuf + offs);
		edge->y         = *(unsigned short*)(dataBuf + offs + 2);
		edge->length    = *(unsigned short*)(dataBuf + offs + 4);
		edge->sector    = *(unsigned short*)(dataBuf + offs + 6);
		edge->otherHalf = *(unsigned short*)(dataBuf + offs + 8);
		offs += 10;
	}

cleanup:
	CloseHandle(hFile);
	free(dataBuf);
	return 0;
}