#include "CViewWnd.h"

static LPTSTR s_lpszWndClassName;

static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static CViewWnd *pThis;
	LPCREATESTRUCT lpcs;

	switch (msg) 
	{
	case WM_NCCREATE:
		lpcs = (LPCREATESTRUCT)lParam;
		pTHis = static_cast<CViewWnd*>(lpcs->lpCreateParams);
		break;
	case WM_CREATE:
		pThis->SetCoolTitle();
		break;
	}

}

ATOM CViewWnd::RegisterWndClass(HINSTANCE hInst)
{
	WNDCLASSEX wc;

	wcex.cbSize			= sizeof(WNDCLASSEX);
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInst;
	wcex.hIcon			= 0;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= 0;
	wcex.lpszClassName	= s_lpszWndClassName;

	return RegisterClassEx(&wc); 
}

CViewWnd::CViewWnd(HWND hWndParent, ATOM wndClass, CMap& map)
	: m_map(map)
{
	m_hWnd = CreateWindowEx(0, wndClass, NULL, WS_CHILD | WS_VISIBLE, 
		0, 0, CW_USEDEFAULT, CW_USEDEFAULT,
		hWndParent, NULL, GetModuleHandle(NULL), this);
	if (m_hWnd == NULL)
	{
		MessageBox(hWndParent, "Failed to create view window.", "Fatal Error",
			MB_ICONERROR | MB_OK);
		return;
	}
}