// MapCrafter.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"

#include <commctrl.h>
#include <commdlg.h>
#include <shellapi.h>
#include <stdio.h>

#pragma comment(lib, "comctl32.lib")

#include "mapdoc.h"
#include "view.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;						// current instance
TCHAR szTitle[MAX_LOADSTRING];			// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];	// The title bar text

static struct MapDocument s_mapdoc;

BOOL isDragging = FALSE;
POINTS ptsDragStart;
POINTS ptsDragEnd;

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	DlgEditSector(HWND, UINT, WPARAM, LPARAM);

VOID MySetTitle(HWND);
BOOL DoOpen(HWND);
BOOL DoSave(HWND, BOOL);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	INITCOMMONCONTROLSEX initCtrls;
	LPSTR lpszFileName;
	MSG msg;
	HACCEL hAccelTable;

	/* TODO: Properly handle command lines with more than just the filename. */
	/* Trim surrounding quotes from file path if needed. */
	lpszFileName = lpCmdLine;
	if (*lpCmdLine == '"') {
		char *chptr = ++lpszFileName;
		while (*chptr != 0 && *chptr != '"')
			++chptr;
		if (*chptr == '"')
			*chptr = 0;
	}

	s_mapdoc = Map_Create();
	if (lpCmdLine) {
		Map_ReadFromFile(&s_mapdoc, lpszFileName);
	}

	initCtrls.dwSize = sizeof(INITCOMMONCONTROLSEX);
	initCtrls.dwICC  = ICC_BAR_CLASSES;
	InitCommonControlsEx(&initCtrls);

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_MAPCRAFTER, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_MAPCRAFTER);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_MAPCRAFTER);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_MAPCRAFTER;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, CW_USEDEFAULT, 620, 390, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	int msgChoice;
	UINT uMenuState;
	PAINTSTRUCT ps;
	HDC hdc;
	RECT rc;

	HDROP hDrop;
	char szDropFile[128];

	POINT ptMouseTopLeft;
	POINT ptMouseBottomRight;

	switch (message) 
	{
		case WM_CREATE:
			DragAcceptFiles(hWnd, TRUE);
			View_Setup();
			MySetTitle(hWnd);
			break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_NEW:
					Map_Destroy(&s_mapdoc);
					s_mapdoc = Map_Create();
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
					MySetTitle(hWnd);
					EnableMenuItem(GetMenu(hWnd), IDM_EDITSECTOR, MF_GRAYED);
					break;
				case IDM_OPEN:
					DoOpen(hWnd);
					RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
					EnableMenuItem(GetMenu(hWnd), IDM_EDITSECTOR, MF_GRAYED);
					break;
				case IDM_SAVE:
					DoSave(hWnd, FALSE);
					break;
				case IDM_SAVEAS:
					DoSave(hWnd, TRUE);
					break;
				case IDM_EDITSECTOR:
					DialogBox(hInst, MAKEINTRESOURCE(IDD_EDITSECTOR), hWnd, (DLGPROC)DlgEditSector);
					break;
				case IDM_ABOUT:
					DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, (DLGPROC)About);
					break;
				case IDM_EXIT:
					DestroyWindow(hWnd);
					break;
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_LBUTTONDOWN:
			ptsDragStart = MAKEPOINTS(lParam);
			uMenuState = MF_ENABLED;
			if (!View_SelectAtPoint(ptsDragStart, &s_mapdoc)) {
				View_StartDrag(ptsDragStart, &s_mapdoc);
				isDragging = TRUE;

				SetCapture(hWnd);
				GetClientRect(hWnd, &rc);
				ptMouseTopLeft.x = rc.left;
				ptMouseTopLeft.y = rc.top;

				ptMouseBottomRight.x = rc.right  + 1; 
				ptMouseBottomRight.y = rc.bottom + 1; 

				ClientToScreen(hWnd, &ptMouseTopLeft); 
				ClientToScreen(hWnd, &ptMouseBottomRight); 

				/* Confine the mouse cursor within the bounds of the window. */
				SetRect(&rc, ptMouseTopLeft.x, ptMouseTopLeft.y,
					ptMouseBottomRight.x, ptMouseBottomRight.y);
				ClipCursor(&rc);

				uMenuState = MF_GRAYED;
			}

			EnableMenuItem(GetMenu(hWnd), IDM_EDITSECTOR, uMenuState);

			/* TODO: Better invalidation rect */
			RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
			break;
		case WM_RBUTTONDOWN:
			View_SetStartPoint(MAKEPOINTS(lParam), &s_mapdoc);
			/* TODO: Better invalidation rect */
			RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
			break;
		case WM_MOUSEMOVE:
			if (isDragging && wParam & MK_LBUTTON) {
				ptsDragEnd = MAKEPOINTS(lParam);
				View_ContinueDrag(ptsDragStart, ptsDragEnd, &s_mapdoc);
				/* TODO: Better invalidation rect */
				RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
			}
			break;
		case WM_LBUTTONUP:
			isDragging = FALSE;
			
			ClipCursor(NULL);
			ReleaseCapture();

			View_EndDrag();
			MySetTitle(hWnd);
			break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rc);
			View_Paint(hdc, &rc, &s_mapdoc);
			EndPaint(hWnd, &ps);
			break;
		case WM_DROPFILES:
			hDrop = (HDROP)wParam;
			DragQueryFile(hDrop, 0, szDropFile, 128);
			if (Map_ReadFromFile(&s_mapdoc, szDropFile) != 0) {
				MessageBox(hWnd, "Unable to read level from file.", "Error", MB_ICONERROR | MB_OK);
				break;
			}
			RedrawWindow(hWnd, NULL, NULL, RDW_INVALIDATE);
			MySetTitle(hWnd);
			break;
		case WM_CLOSE:
			if (s_mapdoc.bNeedsSave) {
				msgChoice = MessageBox(hWnd,
					"Would you like to save your changes?", "Unsaved changes",
					MB_ICONEXCLAMATION | MB_YESNOCANCEL);
				if (msgChoice != IDCANCEL) {
					if (msgChoice == IDYES) {
						DoSave(hWnd, FALSE);
					}
					DestroyWindow(hWnd);
				}
			} else {
					DestroyWindow(hWnd);
			}
			break;
		case WM_DESTROY:
			View_Destroy();
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

LRESULT CALLBACK DlgEditSector(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int floorHeight, ceilHeight;

	switch (message)
	{
		case WM_INITDIALOG:
			if (View_GetSectorHeights(&floorHeight, &ceilHeight)) {
				SetDlgItemInt(hDlg, IDC_EDSC_FLOOR, floorHeight, FALSE);
				SetDlgItemInt(hDlg, IDC_EDSC_CEIL, ceilHeight, FALSE);
			}
			return TRUE;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			case IDOK:
				floorHeight = GetDlgItemInt(hDlg, IDC_EDSC_FLOOR, NULL, FALSE);
				ceilHeight  = GetDlgItemInt(hDlg, IDC_EDSC_CEIL, NULL, FALSE);
				View_SetSectorHeights(floorHeight, ceilHeight);
				s_mapdoc.bNeedsSave = TRUE;
				MySetTitle(GetParent(hDlg));
			case IDCANCEL:
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

VOID MySetTitle(HWND hWnd)
{
	static char titleBuf[128];
	int namelen;
	char *strptr;
	char saveChar = s_mapdoc.bNeedsSave ? '*' : ' ';

	if (s_mapdoc.szFileName == NULL) {
		strptr = "[Untitled]";
	} else {
		/* Trim the string so it's only the last part of the file path */
		namelen = strlen(s_mapdoc.szFileName);
		strptr = s_mapdoc.szFileName + namelen;
		while (*(strptr - 1) != '\\') {
			/* Break if we've reached the beginning of the string. */
			if (strptr == s_mapdoc.szFileName + 1)
				break;
			strptr--;
		}
	}
	
	sprintf(titleBuf, "%s - %s %c", szTitle, strptr, saveChar);
	SetWindowText(hWnd, titleBuf);
}

BOOL DoOpen(HWND hWnd)
{
	char szFilename[260];
	OPENFILENAME ofn;

	ZeroMemory(szFilename, 260);
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= hWnd;
	ofn.lpstrFilter		= "All\0*.*\0MapCrafter Level\0*.kke\0\0";
	ofn.nFilterIndex	= 2;
	ofn.lpstrFile		= szFilename;
	ofn.nMaxFile		= 260;
	ofn.lpstrFileTitle	= NULL;
	ofn.nMaxFileTitle	= 0;
	ofn.lpstrInitialDir	= NULL;
	ofn.Flags			= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	if (GetOpenFileName(&ofn) == 0) {
		return FALSE;
	}

	if (Map_ReadFromFile(&s_mapdoc, szFilename) != 0) {
		MessageBox(hWnd, "Unable to read level from file.", "Error", MB_ICONERROR | MB_OK);
		return FALSE;
	}

	MySetTitle(hWnd);
	return TRUE;
}

BOOL DoSave(HWND hWnd, BOOL bPromptFilename)
{
	char szFilename[260];
	if (bPromptFilename || s_mapdoc.szFileName == NULL) {
		OPENFILENAME ofn;
		const char *szDefExt = ".kke";

		ZeroMemory(szFilename, 260);
	
		ZeroMemory(&ofn, sizeof(OPENFILENAME));
		ofn.lStructSize		= sizeof(OPENFILENAME);
		ofn.hwndOwner		= hWnd;
		ofn.lpstrFilter		= "All\0*.*\0MapCrafter Level\0*.kke\0\0";
		ofn.nFilterIndex	= 2;
		ofn.lpstrFile		= szFilename;
		ofn.nMaxFile		= 260;
		ofn.lpstrFileTitle	= NULL;
		ofn.nMaxFileTitle	= 0;
		ofn.lpstrInitialDir	= NULL;
		ofn.Flags			= OFN_CREATEPROMPT;
		ofn.lpstrDefExt		= szDefExt;

		if (GetSaveFileName(&ofn) == 0) {
			return FALSE;
		}
	} else {
		strcpy(szFilename, s_mapdoc.szFileName);
	}

	Map_CalculateEdges(&s_mapdoc);
	if (Map_WriteToFile(&s_mapdoc, szFilename) != 0) {
		MessageBox(hWnd, "Unable to write level to file.", "Error", MB_ICONERROR | MB_OK);
		return FALSE;
	}

	MySetTitle(hWnd);
	return TRUE;
}
