#ifndef _H_MAPDEFS
#define _H_MAPDEFS

/* Shorthand type definitions for common integer types. */
typedef unsigned char  u8;
typedef unsigned short u16;

#define KKE_MAP_VERSION   2   /* Version of the format described in this header */

/* KKE_MAP_VERSION   history
 *
 * 1:	05/02/2023	Restructured file format, introduced edges.
 * 2:	05/04/2023	Added floor and ceiling heights.
 */

#define KKE_MAX_SECTORS   256
#define KKE_MAX_HALFEDGES 1024

/* Byte sizes of each struct, since the compiler may introduce padding. */
#define KKE_HEADER_SIZE   9
#define KKE_SECTOR_SIZE   10
#define KKE_HALFEDGE_SIZE 10

typedef struct {
	u8  version;
	u16 startX, startY;
	u16 numSectors;
	u16 numHalfEdges;
} kke_header_t;

typedef struct {
	u16 x0, y0; /* top-left corner */
	u16 x1, y1; /* bottom-right corner */
	u8 floorHeight, ceilHeight;
} kke_sector_t;

typedef struct {
	u16 x, y; /* position relative to top-left corner of the sector */
	u16 length;
	u16 sector;
	u16 otherHalf;
} kke_halfedge_t;

#endif
