#ifndef _H_MAPDOC
#define _H_MAPDOC

#include "mapdefs.h"

struct MapDocument {
	kke_header_t   header;
	kke_sector_t   sectors[KKE_MAX_SECTORS];
	kke_halfedge_t edges[KKE_MAX_HALFEDGES];
	char *szFileName;
	int bNeedsSave;
};

struct MapDocument Map_Create();

kke_sector_t *Map_AddSector(struct MapDocument *, kke_sector_t);
void Map_SetFileName(struct MapDocument *, const char *);

void Map_CalculateEdges(struct MapDocument *);

kke_sector_t *Map_SectorAtPoint(const struct MapDocument *, int, int);
/* Check whether a potential sector overlaps with another in the map. */
int Map_IntersectsWithAnother(const struct MapDocument *, const kke_sector_t *);

int Map_ReadFromFile(struct MapDocument *, const char *);
int Map_WriteToFile(struct MapDocument *, const char *);

void Map_Destroy(const struct MapDocument *);

#endif
