/* VIEW.H
 * 
 * Contains functions for drawing a top-down view of the map using the Windows
 * GDI interface.
 */

#ifndef _H_VIEW
#define _H_VIEW

#include "mapdoc.h"
#include "stdafx.h"

void View_Setup();

void View_StartDrag(POINTS, struct MapDocument *);
void View_ContinueDrag(POINTS, POINTS, const struct MapDocument *);
void View_EndDrag();

BOOL View_SelectAtPoint(POINTS, struct MapDocument *);
BOOL View_HasSelection();

BOOL View_GetSectorHeights(int *, int *);
void View_SetSectorHeights(int, int);
void View_SetStartPoint(POINTS, struct MapDocument *);

void View_Paint(HDC, LPRECT, const struct MapDocument *);

void View_Destroy();

#endif
