#ifndef _H_AUDIO
#define _H_AUDIO

#include "RPK.h"

#define SOUND_NONE -1

void Audio_Init(const RPKFile *rpk, const char *devicename);
void Audio_Cleanup(void);

void Audio_ChangeDevice(const char *deviceName);
int Audio_GetIDForName(const char *soundname);

int Audio_DoAudioUpdateLoop(void*);
void Audio_UpdateListener(void);

void Audio_SetVolume(float masterVolume, float sfxVolume, float musicVolume);
void Audio_SetMusic(const char *songName);

void Audio_PlaySound(int id);
void Audio_PlaySound3D(int id, float x, float y, float xd, float yd);

#define AUDIO_MAXDEVICES 12
/* NOTE: This function assumes that devicelist has room for `AUDIO_MAXDEVICES` elements. */
int Audio_GetDeviceList(char **devicelist);

#endif
