#ifndef _H_GUI
#define _H_GUI

#include <stdbool.h>

#include "Bitmap.h"

/* Data structure used by WIDGET_SELECT */
struct GuiSelectData
{
	char **options;
	int numoptions;
	int selected;
};

struct GuiWidget
{
	enum { WIDGET_TEXT, WIDGET_BUTTON, WIDGET_IMAGE, WIDGET_SLIDER, WIDGET_SELECT } type;
	void *data;
	/* NOTE: X and Y coordinates are relative to the menu */
	int x, y;
	int w, h;
};

struct GuiMenu
{
	struct GuiWidget *widgets;
	int numWidgets;
	int selected;
	enum { GUIBG_NONE, GUIBG_RECT, GUIBG_DARKENSCREEN, GUIBG_FILLBG } bgType;
	void (*drawProc)(struct GuiMenu *menu, Bmp_t *screen);
	void (*layoutProc)(struct GuiMenu *menu, Bmp_t *screen);
	void (*clickProc)(int widgetid);
	int xOffs, yOffs;
	int width, height;
	bool layoutComputed;
};

#define GUI_CLOSEMENU -1

int Gui_FirstInteractable(struct GuiMenu *menu);
int Gui_PrevInteractable(struct GuiMenu *menu, int i);
int Gui_NextInteractable(struct GuiMenu *menu, int i);
void Gui_SelectWidget(struct GuiMenu *menu, int i);
void Gui_CloseMenu(struct GuiMenu *menu);

void Gui_DrawMenu(struct GuiMenu *menu, Bmp_t *screen);
/* Computes the positions and sizes of the menu and all of its widgets */
void Gui_LayoutMenu(struct GuiMenu *menu, Bmp_t *screen);
void Gui_HandleLeftRight(struct GuiMenu *menu, int value);
void Gui_HandleMouseMove(struct GuiMenu *menu, bool buttonDown, int mouseX, int mouseY);
void Gui_ClickMenu(const struct GuiMenu *menu, int selected);
void Gui_HandleClick(const struct GuiMenu *menu, int mouseX, int mouseY);

#endif
