#ifndef _H_ITEM
#define _H_ITEM

#include "Bitmap.h"
#include "RPK.h"

#define INVALID_ITEM_TYPE 0xff

enum ItemStatType { ISTAT_NONE, ISTAT_SPEED, ISTAT_RANGE, ISTAT_DAMAGE, ISTAT_BLOCKAMT };

/** Item properties

 * Two handed?
 * Can be placed on belt?
 * Special behaviour:
 *	Armour
 *	Scrolls
 *	Gemstones

 */

/* Special item properties, enables certain hardcoded features for the item */
enum
{
	ISPEC_NONE,
	ISPEC_QUIVER,	/* Has a 'count' that is incremented when an arrow is picked up and decremented when the bow is fired. */

	/* Scrolls: Changes items when used on something in the inventory screen */
	ISPEC_SCROLL_REPAIR,	/* Fully or partially restores durability */
	ISPEC_SCROLL_UPGRADE,	/* Increases a random item stat */

	/* Gemstones: Add effects to player when in belt slot */
	ISPEC_GEM_STRENGTH,	/* Increases player strength */
	ISPEC_GEM_SPEED,
	ISPEC_GEM_MANA,	/* Increases the amount that mana recharges */
};

struct ItemStat
{
	enum ItemStatType type;
	float value;
};

struct ItemType
{
	char *title;
	char *desc;
	int w, h;
	int initialData;
	int special;
	int autoFire;
	int maxUses;
	int minFloor, maxFloor;
	int useAction;
	struct ItemStat baseStats[3];
	Bmp_t invSprite, hudGfx0, hudGfx1;
	int worldSprite;
};

// Instance of an item type that exists in an inventory or in the world. Contains properties that make this item unique from others.
// This struct is sent over the network, and shouldn't contain any pointers.
typedef struct _Item
{
	struct ItemStat stats[3];
	int remainingUses;
	unsigned short type;
	short data;
} Item_t;

/* Global array of all item types */
extern struct ItemType *ItemTypes;

void Items_Init(const RPKFile *);
void Items_Cleanup(void);

/* Defaults to zero if the item doesn't have the specified stat */
float Item_GetStat(const Item_t *, enum ItemStatType);

Item_t Item_GetById(int id);
Item_t Item_GetByName(const char *);
Item_t Loot_PickRandom(int depth);

int Item_SpecialUseOn(Item_t *item, Item_t *target);

#endif
