#ifndef _H_LEVELGEN
#define _H_LEVELGEN

#include "Bitmap.h"
#include "RPK.h"

extern int gNumLevels;
extern int gEnemiesEnabled;

struct SpawnedEntity {
	int type;
	float x, y, z;
	int isBoss;
};

void LvlGen_Init(const RPKFile *rpk);
void LvlGen_Cleanup(void);
int LvlGen_Generate(int depth, int enterX, int enterY, struct SpawnedEntity **spawnedEntities);
void LvlGen_SetLevelProperties(int depth);

Bmp_t *LvlGen_GetSkyboxForFloor(int floor);

#endif
