#ifndef _H_RPAK
#define _H_RPAK

#include <stddef.h>
#include <stdint.h>

typedef unsigned char byte;

#define RPK_FILE_VERSION 3
#define RPK_NAME_LENGTH 20

enum RPK_Flag {
	RPK_FLAG_COMPRESSED = 1
};

typedef struct
{
	char header[4]; /* Always equals "RPAK" */
	byte version;
	byte flags;
	unsigned short numentries;
} RPK_Header;

typedef struct
{
	char name[RPK_NAME_LENGTH];
	uint32_t size;
	uint32_t offset;
	uint32_t origSize; /* Original uncompressed size of the data */
} RPK_TOCEntry;

typedef struct {
	RPK_Header *header;
	RPK_TOCEntry *entries;
	void *data;
} RPKFile;

#ifndef TOOLS

RPKFile *RPK_OpenFile(const char *path);
void RPK_CloseFile(RPKFile *);

int RPK_GetIndexForName(const RPKFile *rpak, const char *name);

/* Returns the size of the newly allocated buffer stored in *dataOut, which should be freed with SDL_free() */
size_t RPK_GetEntryData(const RPKFile *rpak, const char *name, void **dataOut);

#endif

#endif
