#pragma once

#include <string>
#include <unordered_map>
#include <vector>

#include "tokens.hpp"

enum RefType {
	REF_ENTITY,
	REF_ITEM,
	REF_STATE,
	REF_SCRIPT,
	REF_ANY
};

struct Block {
	std::string name;
	std::string type;
	FilePos filepos;
	std::unordered_map<std::string, token> properties;

	int GetInteger(const std::string &name) const;
	int GetOptionalInteger(const std::string &name, int def) const;

	char GetChar(const std::string &name) const;
	char GetOptionalChar(const std::string &name, char def) const;

	float GetFloat(const std::string &name) const;
	float GetOptionalFloat(const std::string &name, float def) const;

	// Returns the index value of the referenced object
	int GetReference(const std::string &name, RefType type = REF_ANY) const;
	// Same as above, but allows "0" as a valid name and
	// returns a default value if none was found
	int GetOptionalReference(const std::string &name, RefType type = REF_ANY) const;

	std::string GetString(const std::string &name) const;
};

struct List {
	std::string name;
	std::string type;
	FilePos filepos;
	std::vector<token> items;

	int GetInteger(size_t index) const;
	int GetOptionalReference(size_t index, RefType type = REF_ANY) const;
	std::string GetName(size_t index) const;
};
