#pragma once

#include <cstdint>
#include <filesystem>
#include <string>
#include <vector>

class ByteBuffer
{
public:
	// Basic integer types, written in little endian format
	void WriteUInt8(uint8_t v);
	void WriteUInt16(uint16_t v);
	void WriteUInt32(uint32_t v);

	void WriteInt8(int8_t v);
	void WriteInt16(int16_t v);
	void WriteInt32(int32_t v);
	void WriteFloat(float v);

	void OverwriteUInt32(size_t offs, uint32_t v);

	void WriteBytes(void *data, size_t len);
	void FillZero(size_t num);

	void CopyFrom(const ByteBuffer &);

	// Write a string with a fixed length to the buffer.
	// If the string is smaller than the max length, it will be padded with null terminating bytes.
	void WriteFixedString(const std::string &str, int maxlen);

	// Write a dynamic length string, preceeded by a byte telling how long the string is
	void WriteLengthString(const std::string &str);

	size_t size() const { return m_buffer.size(); }
	void clear() { m_buffer.clear(); }

	void SaveToFile(const std::filesystem::path &path) const;

private:
	std::vector<uint8_t> m_buffer;
};
