#include "error.hpp"

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#endif

#include <cstdarg>
#include <iostream>

void PrintErrorMsg(const FilePos &filePos, int level, const char *fmt, ...)
{
	va_list args;
	char msgBuffer[1024];

#ifdef _WIN32
	CONSOLE_SCREEN_BUFFER_INFO screenInfo;
	HANDLE hConsole;

	// Get console attributes and set colour to red
	hConsole = GetStdHandle(STD_ERROR_HANDLE);
	GetConsoleScreenBufferInfo(hConsole, &screenInfo);
	SetConsoleTextAttribute(hConsole, FOREGROUND_RED);
#endif

	// Write formatted message string
	va_start(args, fmt);
	vsprintf(msgBuffer, fmt, args);
	va_end(args);

#ifndef _WIN32
	std::cerr << "\033[31m";
#endif
	std::cerr << filePos.file << ':' << filePos.line << ": " << msgBuffer << std::endl;
#ifndef _WIN32
	std::cerr << "\033[0m";
#endif
#ifdef _WIN32
	// Reset console colour
	SetConsoleTextAttribute(hConsole, screenInfo.wAttributes);
#endif

	if (level == ERR_LVL_ERROR)
		exit(1);
}
