#pragma once

#include "tokens.hpp"
#include <vector>

class ByteBuffer;

enum ASTNodeType {
	ASTNODE_SEQ,
	ASTNODE_IFELSE,	// 0 = condition, 1 = true branch, 2 = false branch (optional)
	ASTNODE_UNARYOP,
	ASTNODE_BINARYOP,
	ASTNODE_ASSIGNMENT,
	ASTNODE_FUNC,
	ASTNODE_LITERAL,
	ASTNODE_LVALUE,	// maybe merge with register
	ASTNODE_REGISTER
};

struct ASTNode {
	ASTNodeType type;
	token value;
	std::vector<ASTNode> subNodes;
};

// First step of compilation: Use the token reader to build an AST.
// Returns the root AST node of the script to be compiled later.
ASTNode ParseScript(TokenReader &reader);

void DumpAST(const ASTNode &root, int level = 0);
